/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.gui;

import com.google.common.base.Strings;
import com.hrznstudio.emojiful.ClientProxy;
import com.hrznstudio.emojiful.gui.IDrawableGuiListener;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class EmojiSuggestionHelper
implements IDrawableGuiListener {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private final ChatScreen chatScreen;
    private CompletableFuture<Suggestions> suggestionsFuture;
    private EmojiSuggestions suggestions;
    private boolean updating;
    private String inputFieldTextLast;

    public EmojiSuggestionHelper(ChatScreen screen) {
        this.chatScreen = screen;
        this.updating = false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.suggestions != null && this.suggestions.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 258) {
            this.updateSuggestionList(false);
            return this.suggestions != null;
        }
        return false;
    }

    public void updateSuggestionList(boolean skip) {
        StringReader stringreader;
        String s = this.chatScreen.f_95573_.m_94155_();
        if (!this.updating) {
            this.chatScreen.f_95573_.m_94167_(null);
            this.suggestions = null;
        }
        if ((stringreader = new StringReader(s)).canRead()) {
            int cursorPosition = this.chatScreen.f_95573_.m_94207_();
            int lastWordIndex = EmojiSuggestionHelper.getLastWordIndex(s);
            if (!(!(lastWordIndex < s.length() ? s.charAt(lastWordIndex) == ':' : s.length() > 0 && s.charAt(0) == ':') || !skip && cursorPosition - lastWordIndex < 3 || this.suggestions != null && this.updating)) {
                CompletableFuture<Iterable> list = CompletableFuture.supplyAsync(() -> ClientProxy.ALL_EMOJIS);
                this.suggestionsFuture = list.thenApplyAsync(stringIterable -> EmojiSuggestionHelper.createSuggestions(stringIterable, new SuggestionsBuilder(s, lastWordIndex)));
                this.suggestionsFuture.thenRun(() -> {
                    if (this.suggestionsFuture.isDone()) {
                        this.showSuggestions();
                    }
                });
            }
        }
    }

    public void showSuggestions() {
        if (this.suggestionsFuture != null && this.suggestionsFuture.isDone()) {
            int i = 0;
            Suggestions suggestions = this.suggestionsFuture.join();
            if (!suggestions.getList().isEmpty()) {
                for (Suggestion suggestion : suggestions.getList()) {
                    i = Math.max(i, ClientProxy.oldFontRenderer.m_92895_(suggestion.getText()));
                }
                int j = Minecraft.m_91087_().f_91062_.m_92895_(this.chatScreen.f_95573_.m_94155_().substring(0, this.chatScreen.f_95573_.m_94207_() - suggestions.getRange().getLength() + 2));
                this.suggestions = new EmojiSuggestions(j, this.chatScreen.f_96544_ - 12, i, suggestions);
            }
        }
    }

    private static Suggestions createSuggestions(Iterable<String> collection, SuggestionsBuilder suggestionBuilder) {
        String remaining = suggestionBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (String key : collection) {
            if (!key.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            suggestionBuilder.suggest(key);
        }
        return suggestionBuilder.build();
    }

    private static int getLastWordIndex(String p_228121_0_) {
        if (Strings.isNullOrEmpty((String)p_228121_0_)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(p_228121_0_);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static String trim(String text, String textAll) {
        return textAll.startsWith(text) ? textAll.substring(text.length()) : null;
    }

    @Override
    public void render(PoseStack matrixStack) {
        if (this.suggestions != null) {
            this.suggestions.render(matrixStack);
        }
        this.checkTextUpdate();
    }

    public void checkTextUpdate() {
        String inputFieldText = this.chatScreen.f_95573_.m_94155_();
        if (!StringUtils.equals((CharSequence)this.inputFieldTextLast, (CharSequence)inputFieldText)) {
            this.inputFieldTextLast = inputFieldText;
            this.updateSuggestionList(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EmojiSuggestions {
        private final Rect2i area;
        private final Suggestions suggestions;
        private String currentText;
        private int index;

        public EmojiSuggestions(int x, int y, int areaWidth, Suggestions suggestions) {
            this.suggestions = suggestions;
            int n = Math.min(suggestions.getList().size(), 10);
            Objects.requireNonNull(ClientProxy.oldFontRenderer);
            int height = n * (9 + 3);
            this.area = new Rect2i(x - 1, y - 3 - height, areaWidth, height);
            this.currentText = EmojiSuggestionHelper.this.chatScreen.f_95573_.m_94155_();
            this.setIndex(0);
        }

        public void render(PoseStack stack) {
            for (int i = 0; i < Math.min(this.suggestions.getList().size(), 10); ++i) {
                int pos = (this.index + i) % this.suggestions.getList().size();
                Suggestion suggestion = (Suggestion)this.suggestions.getList().get(pos);
                GuiComponent.m_93172_((PoseStack)stack, (int)this.area.m_110085_(), (int)(this.area.m_110086_() + 12 * i), (int)(this.area.m_110085_() + this.area.m_110090_() + 15), (int)(this.area.m_110086_() + 12 * i + 12), (int)-805306368);
                Minecraft.m_91087_().f_91062_.m_92750_(stack, suggestion.getText(), (float)(this.area.m_110085_() + 1), (float)(this.area.m_110086_() + 2 + 12 * i), pos == this.index ? -256 : -5592406);
                ClientProxy.oldFontRenderer.m_92750_(stack, suggestion.getText(), (float)(12 + this.area.m_110085_() + 1), (float)(this.area.m_110086_() + 2 + 12 * i), pos == this.index ? -256 : -5592406);
            }
        }

        public void setIndex(int i) {
            this.index = i;
            if (this.index < 0) {
                this.index = this.suggestions.getList().size() - 1;
            } else if (this.index >= this.suggestions.getList().size()) {
                this.index = 0;
            }
            EmojiSuggestionHelper.this.chatScreen.f_95573_.m_94167_(EmojiSuggestionHelper.trim(EmojiSuggestionHelper.this.chatScreen.f_95573_.m_94155_(), ((Suggestion)this.suggestions.getList().get(this.index)).apply(this.currentText)));
        }

        public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 265) {
                this.offsetIndex(-1);
                return true;
            }
            if (keyCode == 264) {
                this.offsetIndex(1);
                return true;
            }
            if (keyCode == 258) {
                this.applySuggestion();
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.applySuggestion();
                return true;
            }
            if (keyCode == 256) {
                this.removeSuggestion();
                return true;
            }
            if (keyCode == 262 || keyCode == 263) {
                EmojiSuggestionHelper.this.chatScreen.f_95573_.m_94167_("");
                this.removeSuggestion();
                return false;
            }
            return false;
        }

        public void offsetIndex(int deltaIndex) {
            this.setIndex(this.index + deltaIndex);
        }

        public void removeSuggestion() {
            EmojiSuggestionHelper.this.suggestions = null;
        }

        public void applySuggestion() {
            Suggestion suggestion = (Suggestion)this.suggestions.getList().get(this.index);
            EmojiSuggestionHelper.this.updating = true;
            EmojiSuggestionHelper.this.chatScreen.f_95573_.m_94144_(suggestion.apply(this.currentText));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            EmojiSuggestionHelper.this.chatScreen.f_95573_.m_94192_(i);
            EmojiSuggestionHelper.this.chatScreen.f_95573_.m_94208_(i);
            this.setIndex(this.index);
            EmojiSuggestionHelper.this.updating = false;
        }
    }
}

